#ifdef JA2_PRECOMPILED_HEADERS
	#include "JA2 SGP ALL.H"
#elif defined( WIZ8_PRECOMPILED_HEADERS )
	#include "WIZ8 SGP ALL.H"
#else
	#include "DirectX Common.h"
	#include "DirectDraw Calls.h"

	#include <ddraw.h>
	#include "debug.h"
	#include "video_private.h"
#endif

// DirectDrawSurface7 Calls
void
DDCreateSurface (	LPDIRECTDRAW7 pExistingDirectDraw,
								DDSURFACEDESC2 *pNewSurfaceDesc,
								LPDIRECTDRAWSURFACE7 *ppNewSurface )
{
	Assert ( pExistingDirectDraw != NULL );
	Assert ( pNewSurfaceDesc != NULL );
	Assert ( ppNewSurface != NULL );

	// create the directdraw surface
	ATTEMPT ( IDirectDraw7_CreateSurface ( pExistingDirectDraw,
						pNewSurfaceDesc, ppNewSurface, NULL ) );
}


// DirectDrawSurface7 Calls
void
DDCreateSurfaceInMemory ( LPDIRECTDRAW7 pExistingDirectDraw,
								DDSURFACEDESC2 *pNewSurfaceDesc,
								BOOLEAN fVideoMemory,
								LPDIRECTDRAWSURFACE7 *ppNewSurface )
{
	DDSURFACEDESC2	DDSurfaceDesc;
	BOOLEAN			fDestination;

	Assert ( pExistingDirectDraw != NULL );
	Assert ( pNewSurfaceDesc != NULL );
	Assert ( ppNewSurface != NULL );

	// copy to a local so we don't change the input parameter
	memcpy ( &DDSurfaceDesc, pNewSurfaceDesc, sizeof ( DDSURFACEDESC2 ) );
	
	// must have caps set since we are adding to the ddsCaps element
	DDSurfaceDesc.dwFlags |= DDSD_CAPS;

	// If this is a hardware D3D driver, the Z-Buffer MUST end up in video
	// memory.  Otherwise, it MUST end up in system memory.
	if ( fVideoMemory )
		DDSurfaceDesc.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		DDSurfaceDesc.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

	// create the surface
	DDCreateSurface ( pExistingDirectDraw, &DDSurfaceDesc, ppNewSurface );

   // get surface information
	DDGetSurfaceDescription ( *ppNewSurface, &DDSurfaceDesc );

	// was the surface created in video memory?
	fDestination = ( DDSurfaceDesc.ddsCaps.dwCaps & DDSCAPS_VIDEOMEMORY ) ?
													TRUE : FALSE;

	// did we create the surface in the right memory area?
	if ( fDestination != fVideoMemory )
	{
		// nope we couldn't do it right so release the newly created surface
		// and pass back a NULL pointer to the user
		DDReleaseSurface ( ppNewSurface );
	}
}

// Lock, unlock calls
void DDLockSurface ( LPDIRECTDRAWSURFACE7 pSurface, LPRECT pDestRect, LPDDSURFACEDESC2 pSurfaceDesc, UINT32 uiFlags, HANDLE hEvent )
{
	HRESULT ReturnCode;

	Assert( pSurface != NULL );
	Assert( pSurfaceDesc != NULL );

	ZEROMEM ( *pSurfaceDesc );
	pSurfaceDesc->dwSize = sizeof(DDSURFACEDESC2);

	do
	{
		ReturnCode = IDirectDrawSurface7_Lock( pSurface, pDestRect, pSurfaceDesc, uiFlags, hEvent);

	} while( ReturnCode == DDERR_WASSTILLDRAWING );

	ATTEMPT( ReturnCode );

}

void DDUnlockSurface( LPDIRECTDRAWSURFACE7 pSurface, PTR pSurfaceData )
{
	Assert( pSurface != NULL );

//<SB>
//	ATTEMPT( IDirectDrawSurface7_Unlock( pSurface, pSurfaceData ) );
// not so correct, but PRECT always == NULL in source code
	ATTEMPT( IDirectDrawSurface7_Unlock( pSurface, NULL ) );
//</SB>

}


void DDGetSurfaceDescription ( LPDIRECTDRAWSURFACE7 pSurface, DDSURFACEDESC2 *pSurfaceDesc )
{
	Assert ( pSurface != NULL );
	Assert ( pSurfaceDesc != NULL );

	ZEROMEM ( *pSurfaceDesc );
	pSurfaceDesc->dwSize = sizeof ( DDSURFACEDESC2 );

	ATTEMPT ( IDirectDrawSurface7_GetSurfaceDesc ( pSurface, pSurfaceDesc ) );
}

void DDGetSurfaceCaps ( LPDIRECTDRAWSURFACE7 pSurface, DDSCAPS2 *pSurfaceCaps )
{
	Assert( pSurface != NULL  );
	Assert( pSurfaceCaps != NULL );

	ATTEMPT( IDirectDrawSurface7_GetCaps( pSurface, pSurfaceCaps ) );

}

void DDCreateRasterSurface ( LPDIRECTDRAW7 pDirectDraw, INT32 iWidth, INT32 iHeight,
									  BOOLEAN fVideoMemory,
									  LPDIRECTDRAWSURFACE7 *ppRasterSurface )
{
	DDSURFACEDESC2	DDSurfaceDesc;

	// validate used portions of the structure
	Assert ( pDirectDraw != NULL );
	Assert ( iWidth != 0 );
	Assert ( iHeight != 0 );
	Assert ( ppRasterSurface != NULL );

	// create the raster surface
	ZEROMEM ( DDSurfaceDesc );
	DDSurfaceDesc.dwSize		= sizeof ( DDSurfaceDesc );
	DDSurfaceDesc.dwFlags	= DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	DDSurfaceDesc.dwWidth	= iWidth;
	DDSurfaceDesc.dwHeight	= iHeight;
	DDSurfaceDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_OFFSCREENPLAIN;
	DDCreateSurfaceInMemory ( pDirectDraw, &DDSurfaceDesc, fVideoMemory, ppRasterSurface );
}

void DDCreateZBufferSurface ( LPDIRECTDRAW7 pDirectDraw, INT32 iWidth, INT32 iHeight,
									  BOOLEAN fVideoMemory,
									  LPDIRECTDRAWSURFACE7 *ppZBufferSurface )
{
	DDSURFACEDESC2	DDSurfaceDesc;

	// validate used portions of the structure
	Assert ( pDirectDraw != NULL );
	Assert ( iWidth != 0 );
	Assert ( iHeight != 0 );
	Assert ( ppZBufferSurface != NULL );

	// create the z buffer
	ZEROMEM ( DDSurfaceDesc );
	DDSurfaceDesc.dwSize		= sizeof ( DDSurfaceDesc );
	DDSurfaceDesc.dwFlags	= DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_ZBUFFERBITDEPTH;
	DDSurfaceDesc.dwWidth	= iWidth;
	DDSurfaceDesc.dwHeight	= iHeight;
//	DDSurfaceDesc.dwZBufferBitDepth	= 16;
	DDSurfaceDesc.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);
	DDSurfaceDesc.ddpfPixelFormat.dwFlags = DDPF_ZBUFFER;
	DDSurfaceDesc.ddpfPixelFormat.dwZBufferBitDepth = 16;
//
	DDSurfaceDesc.ddsCaps.dwCaps		= DDSCAPS_ZBUFFER;
	DDCreateSurfaceInMemory ( pDirectDraw, &DDSurfaceDesc, fVideoMemory, ppZBufferSurface );
}

void
DDAddAttachedSurface (	LPDIRECTDRAWSURFACE7 pParentSurface,
							LPDIRECTDRAWSURFACE7 pAddChildSurface )
{
	Assert ( pParentSurface != NULL  );
	Assert ( pAddChildSurface != NULL );
	
	// attach the child to the parent surface
	ATTEMPT ( IDirectDrawSurface7_AddAttachedSurface ( pParentSurface,
								pAddChildSurface ) );
}

void
DDDeleteAttachedSurface (	LPDIRECTDRAWSURFACE7 pParentSurface,
							LPDIRECTDRAWSURFACE7 pDeleteChildSurface )
{
	Assert ( pParentSurface != NULL  );
	Assert ( pDeleteChildSurface != NULL );

	// seperate the z buffer surface from the raster surface
	ATTEMPT ( IDirectDrawSurface7_DeleteAttachedSurface ( pParentSurface,
									0, pDeleteChildSurface ) );
}

void
DDReleaseSurface ( LPDIRECTDRAWSURFACE7 *ppOldSurface )
{
	Assert ( ppOldSurface != NULL );
	Assert ( *ppOldSurface != NULL );

	ATTEMPT ( IDirectDrawSurface7_Release ( *ppOldSurface ) );

	*ppOldSurface = NULL;
}

void DDRestoreSurface( LPDIRECTDRAWSURFACE7 pSurface )
{
	Assert( pSurface != NULL );

	ATTEMPT( IDirectDrawSurface7_Restore( pSurface ) );
}


void DDBltFastSurface( LPDIRECTDRAWSURFACE7 pDestSurface, UINT32 uiX, UINT32 uiY, LPDIRECTDRAWSURFACE7 pSrcSurface, 
							LPRECT pSrcRect, UINT32 uiTrans)
{
	HRESULT ReturnCode;

	Assert( pDestSurface != NULL  );
	Assert( pSrcSurface != NULL  );

	do
	{
		ReturnCode = IDirectDrawSurface7_SGPBltFast( pDestSurface, uiX, uiY, pSrcSurface, pSrcRect, uiTrans );

	} while( ReturnCode == DDERR_WASSTILLDRAWING );
}


void DDBltSurface( LPDIRECTDRAWSURFACE7 pDestSurface, LPRECT pDestRect, LPDIRECTDRAWSURFACE7 pSrcSurface,
					    LPRECT pSrcRect, UINT32 uiFlags, LPDDBLTFX pDDBltFx )
{

	HRESULT ReturnCode;

	Assert( pDestSurface != NULL  );

	do
	{
		ReturnCode = IDirectDrawSurface7_SGPBlt( pDestSurface, pDestRect, pSrcSurface, pSrcRect, uiFlags, pDDBltFx );

	} while( ReturnCode == DDERR_WASSTILLDRAWING );

	ATTEMPT( ReturnCode );
}


void DDCreatePalette( LPDIRECTDRAW7 pDirectDraw, UINT32 uiFlags, LPPALETTEENTRY pColorTable, LPDIRECTDRAWPALETTE FAR *ppDDPalette,
								IUnknown FAR * pUnkOuter)
{

	Assert( pDirectDraw != NULL );

	ATTEMPT( IDirectDraw7_CreatePalette( pDirectDraw, uiFlags, pColorTable, ppDDPalette, pUnkOuter ) );

}

void DDSetSurfacePalette( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWPALETTE pDDPalette )
{
	Assert( pDDPalette != NULL  );
	Assert( pSurface != NULL );

	ATTEMPT( IDirectDrawSurface7_SetPalette( pSurface, pDDPalette ) );

}

void DDGetSurfacePalette( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWPALETTE *ppDDPalette )
{
	Assert( ppDDPalette != NULL );
	Assert( pSurface != NULL );

	ATTEMPT( IDirectDrawSurface7_GetPalette( pSurface, ppDDPalette ) );

}

void DDSetPaletteEntries( LPDIRECTDRAWPALETTE pPalette, UINT32 uiFlags, UINT32 uiStartingEntry,
								UINT32 uiCount, LPPALETTEENTRY pEntries )
{
	Assert( pPalette != NULL );
	Assert( pEntries != NULL );

	ATTEMPT( IDirectDrawPalette_SetEntries( pPalette, uiFlags, uiStartingEntry, uiCount, pEntries ) );		

}

void DDGetPaletteEntries( LPDIRECTDRAWPALETTE pPalette, UINT32 uiFlags, UINT32 uiBase,
								UINT32 uiNumEntries, LPPALETTEENTRY pEntries )
{
	Assert( pPalette != NULL );
	Assert( pEntries != NULL );

	ATTEMPT( IDirectDrawPalette_GetEntries( pPalette, uiFlags, uiBase, uiNumEntries, pEntries ) );		

}

void DDReleasePalette( LPDIRECTDRAWPALETTE pPalette )
{
	Assert( pPalette != NULL );

	ATTEMPT( IDirectDrawPalette_Release( pPalette ) );
}

void DDGetDC( LPDIRECTDRAWSURFACE7 pSurface, HDC *phDC )
{

	Assert( pSurface != NULL );
	Assert( phDC != NULL );

	ATTEMPT( IDirectDrawSurface7_GetDC( pSurface, phDC ) );

}

void DDReleaseDC( LPDIRECTDRAWSURFACE7 pSurface, HDC hDC )
{

	Assert( pSurface != NULL );

	ATTEMPT( IDirectDrawSurface7_ReleaseDC( pSurface, hDC ) );

}

void DDSetSurfaceColorKey( LPDIRECTDRAWSURFACE7 pSurface, UINT32 uiFlags, LPDDCOLORKEY pDDColorKey )
{
	Assert( pSurface != NULL );
	Assert( pDDColorKey != NULL );

	ATTEMPT( IDirectDrawSurface7_SetColorKey( pSurface, uiFlags, pDDColorKey ) );

}

void DDGetDDInterface( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAW7 *ppDirectDraw )
{
	Assert( pSurface != NULL );
	Assert( ppDirectDraw != NULL );

	ATTEMPT( IDirectDrawSurface7_GetDDInterface( pSurface, ppDirectDraw ) );
}

// Clipper FUnctions
void DDCreateClipper( LPDIRECTDRAW7 pDirectDraw, UINT32 fFlags, LPDIRECTDRAWCLIPPER *pDDClipper )
{
	Assert( pDirectDraw != NULL );
	Assert( pDDClipper != NULL );

	ATTEMPT( IDirectDraw7_CreateClipper( pDirectDraw, 0, pDDClipper, NULL ) );

}

void DDSetClipper( LPDIRECTDRAWSURFACE7 pSurface, LPDIRECTDRAWCLIPPER pDDClipper )
{
	Assert( pSurface != NULL );
	Assert( pDDClipper != NULL );

	ATTEMPT( IDirectDrawSurface7_SetClipper( pSurface, pDDClipper ) );

}

void DDReleaseClipper( LPDIRECTDRAWCLIPPER pDDClipper )
{
	Assert( pDDClipper != NULL );

	ATTEMPT( IDirectDrawClipper_Release( pDDClipper ) );
}

void DDSetClipperList( LPDIRECTDRAWCLIPPER pDDClipper, LPRGNDATA pClipList, UINT32 uiFlags)
{
	Assert( pDDClipper != NULL );
	Assert( pClipList != NULL );
	
	ATTEMPT( IDirectDrawClipper_SetClipList( pDDClipper, pClipList, uiFlags ) );
}



HRESULT BltFastDDSurfaceUsingSoftware( LPDIRECTDRAWSURFACE7 pDestSurface, INT32 uiX, INT32 uiY, LPDIRECTDRAWSURFACE7 pSrcSurface, LPRECT pSrcRect, UINT32 uiTrans )
{
	DDSURFACEDESC2 SurfaceDescription;
	UINT32 uiDestPitchBYTES, uiSrcPitchBYTES;
	UINT8	 *pDestBuf, *pSrcBuf;
  HRESULT       ReturnCode;
  DDCOLORKEY    ColorKey;
	UINT16				us16BPPColorKey;


	// Lock surfaces
	DDLockSurface( (LPDIRECTDRAWSURFACE7)pDestSurface, NULL, &SurfaceDescription, 0, NULL);
	uiDestPitchBYTES = SurfaceDescription.lPitch;
	pDestBuf				 = SurfaceDescription.lpSurface;


	// Lock surfaces
	DDLockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL, &SurfaceDescription, 0, NULL);
	uiSrcPitchBYTES = SurfaceDescription.lPitch;
	pSrcBuf				 = SurfaceDescription.lpSurface;

	if ( uiTrans == DDBLTFAST_NOCOLORKEY )
	{
		Blt16BPPTo16BPP( (UINT16 *)pDestBuf, uiDestPitchBYTES, 
					(UINT16 *)pSrcBuf, uiSrcPitchBYTES,  
					uiX , uiY, 
					pSrcRect->left , pSrcRect->top, 
					( pSrcRect->right - pSrcRect->left ), 
					( pSrcRect->bottom - pSrcRect->top ) );
	}
	else if ( uiTrans == DDBLTFAST_SRCCOLORKEY )
	{
		// Get 16 bpp color key.....
		ReturnCode = IDirectDrawSurface7_GetColorKey( pSrcSurface, DDCKEY_SRCBLT, &ColorKey);

	  if (ReturnCode == DD_OK)
		{
			us16BPPColorKey = (UINT16)ColorKey.dwColorSpaceLowValue;

			Blt16BPPTo16BPPTrans( (UINT16 *)pDestBuf, uiDestPitchBYTES, 
						(UINT16 *)pSrcBuf, uiSrcPitchBYTES,  
						uiX , uiY, 
						pSrcRect->left , pSrcRect->top, 
						( pSrcRect->right - pSrcRect->left ), 
						( pSrcRect->bottom - pSrcRect->top ), us16BPPColorKey );

		}
	}
	else 
	{
		// Not supported.....
	}


	DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pDestSurface, NULL );
	DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL );

	return( DD_OK );
}


HRESULT BltDDSurfaceUsingSoftware( LPDIRECTDRAWSURFACE7 pDestSurface, LPRECT pDestRect, LPDIRECTDRAWSURFACE7 pSrcSurface, LPRECT pSrcRect, UINT32 uiFlags, LPDDBLTFX pDDBltFx )
{
	DDSURFACEDESC2 SurfaceDescription;
	UINT32 uiDestPitchBYTES, uiSrcPitchBYTES;
	UINT8	 *pDestBuf, *pSrcBuf;
  HRESULT       ReturnCode;
  DDCOLORKEY    ColorKey;
	UINT16				us16BPPColorKey;


	// Lock surfaces
	DDLockSurface( (LPDIRECTDRAWSURFACE7)pDestSurface, NULL, &SurfaceDescription, 0, NULL);
	uiDestPitchBYTES = SurfaceDescription.lPitch;
	pDestBuf				 = SurfaceDescription.lpSurface;


	if ( pSrcSurface != NULL )
	{
		// Lock surfaces
		DDLockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL, &SurfaceDescription, 0, NULL);
		uiSrcPitchBYTES = SurfaceDescription.lPitch;
		pSrcBuf				 = SurfaceDescription.lpSurface;
	}

	if ( pSrcRect != NULL && 
			 ( ( pSrcRect->right - pSrcRect->left ) != ( pDestRect->right - pDestRect->left ) ||
			 ( pSrcRect->bottom - pSrcRect->top ) != ( pDestRect->bottom - pDestRect->top ) ) )
	{
		DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pDestSurface, NULL );

		if ( pSrcSurface != NULL )
		{
			DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL );
		}

		// Fall back to DD
		IDirectDrawSurface7_Blt( pDestSurface, pDestRect, pSrcSurface, pSrcRect, uiFlags, pDDBltFx );

		return( DD_OK );
	}
	else if ( uiFlags == DDBLT_WAIT )
	{
		// Lock surfaces
		DDLockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL, &SurfaceDescription, 0, NULL);
		uiSrcPitchBYTES = SurfaceDescription.lPitch;
		pSrcBuf				 = SurfaceDescription.lpSurface;

		Blt16BPPTo16BPP( (UINT16 *)pDestBuf, uiDestPitchBYTES, 
					(UINT16 *)pSrcBuf, uiSrcPitchBYTES,  
					pDestRect->left , pDestRect->top, 
					pSrcRect->left , pSrcRect->top, 
					( pSrcRect->right - pSrcRect->left ), 
					( pSrcRect->bottom - pSrcRect->top ) );
	}
	else if ( uiFlags & DDBLT_KEYSRC )
	{
		// Get 16 bpp color key.....
		ReturnCode = IDirectDrawSurface7_GetColorKey( pSrcSurface, DDCKEY_SRCBLT, &ColorKey);

	  if (ReturnCode == DD_OK)
		{
			us16BPPColorKey = (UINT16)ColorKey.dwColorSpaceLowValue;

			Blt16BPPTo16BPPTrans( (UINT16 *)pDestBuf, uiDestPitchBYTES, 
						(UINT16 *)pSrcBuf, uiSrcPitchBYTES,  
						pDestRect->left , pDestRect->top, 
						pSrcRect->left , pSrcRect->top, 
						( pSrcRect->right - pSrcRect->left ), 
						( pSrcRect->bottom - pSrcRect->top ), us16BPPColorKey );

		}
	}
	else if ( uiFlags & DDBLT_COLORFILL )
	{
		// do color fill here...
		FillRect16BPP( (UINT16 *)pDestBuf, uiDestPitchBYTES, pDestRect->left, pDestRect->top, pDestRect->right, pDestRect->bottom, (UINT16)pDDBltFx->dwFillColor );
	}
	else
	{
		// Not supported.....
	}


	DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pDestSurface, NULL );

	if ( pSrcSurface != NULL )
	{
		DDUnlockSurface( (LPDIRECTDRAWSURFACE7)pSrcSurface, NULL );
	}

	return( DD_OK );
}
